/**
 * @file task_lcd.h
 * @brief Deals with LCD-related tasks
 */
#pragma once

#ifndef __TASK_LCD_H__
#define __TASK_LCD_H__

#include <stdint.h>

#include "Goldelox_Types4D.h"

#define LCD_WIDTH 128
#define LCD_HEIGHT 128

#define BOOT_CIRCL_RAD 30
#define BOOT_STRAP_WIDTH 30
#define BOOT_CIRCL_OFFSET 30

#define APPSCR_PAD 5
#define APPSCR_RCNUM 4 
#define APPSCR_PADCALCW(x) (LCD_WIDTH - (APPSCR_RCNUM  * APPSCR_PAD)) \
    / APPSCR_RCNUM + ((x) * APPSCR_PAD)
#define APPSCR_PADCALCH(x) (LCD_HEIGHT - (APPSCR_RCNUM  * APPSCR_PAD)) \
    / APPSCR_RCNUM + ((x) * APPSCR_PAD)
#define APPSCR_TOPCALCW(x) ((x) * APPSCR_PAD) + (((x) - 1) * APPSCR_PADCALCW(0))
#define APPSCR_TOPCALCH(x) ((x) * APPSCR_PAD) + (((x) - 1) * APPSCR_PADCALCH(0))

/* home screen lcd width and height */

#define LCD_HWIDTH 128
#define LCD_HHEIGHT 112
/* v stands for variale */
#define APPSCR_PADCALCVW(n, pad) (LCD_HWIDTH - (n)  * (pad)) / (n)
#define APPSCR_PADCALCVH(n, pad) (LCD_HHEIGHT - (n)  * (pad)) / (n)
#define APPSCR_TOPCALCVW(n, pad, x) ((x) * (pad)) + \
    (((x) - 1) * APPSCR_PADCALCVW(n, pad))
#define APPSCR_TOPCALCVH(n, pad, x) ((x) * (pad)) + \
    (((x) - 1) * APPSCR_PADCALCVH(n, pad))

#define CLOCKSCR_CIRCRAD 50
/* time markers (hour) length */
#define CLOCKSCR_TIMEMKHR 6 

/* time hand (hour) length */
#define CLOCKSCR_TIMEHDHR 20
/* time hand (min) length */
#define CLOCKSCR_TIMEHDMN 30
/* time hand (sec) length */
#define CLOCKSCR_TIMEHDSE 45

/* digital clock spacing */

#define NUM_APPS 4

typedef void (*app_fn_t) (gl_display_t *);


struct lcd_icon_t {
    uint8_t width;
    uint8_t height;
    uint16_t *data;
};


struct app_t {
    app_fn_t fn;
    struct lcd_icon_t icon;
    char *name;
};


void lcd_homepage_loop(gl_display_t *);

void lcd_clock_loop(gl_display_t *);

void lcd_boot_flash(gl_display_t *, uint8_t);

void lcd_boot_flash_app(gl_display_t *);

void lcd_task(void);



#endif
