/**
 * @file task_button.h
 * @brief Creates a queue to deal with button inputs.
 */

#pragma once

#ifndef __TASK_BUTTON_H__
#define __TASK_BUTTON_H__
#include "freertos/FreeRTOS.h"
#include "iot_button.h"

#define NUM_BUTTONS 5
#define NUM_EVENTS 10
#define EVENT_Q_SIZE 10
extern QueueHandle_t gt_btnq;


enum gt_btn_t {
    GT_BTN_WHITE = 0,
    GT_BTN_GREEN,
    GT_BTN_YELLOW,
    GT_BTN_BLUE,
    GT_BTN_RED
};


struct gt_btn_msg_t {
    enum gt_btn_t btn;
    button_event_t evt;
};


/**
 * @brief Setup button interrupts.
 */
void gt_btn_setup(void);
#endif
