#include "freertos/FreeRTOS.h"
#include "iot_button.h"
#include "button_gpio.h"
#include "esp_log.h"

#include "pins.h"

#include "task_button.h"

/* globals */

QueueHandle_t gt_btnq;


static struct gt_btn_msg_t btn_evts[10] = {
    {GT_BTN_WHITE, BUTTON_SINGLE_CLICK},
    {GT_BTN_WHITE, BUTTON_DOUBLE_CLICK},
    {GT_BTN_GREEN, BUTTON_SINGLE_CLICK},
    {GT_BTN_GREEN, BUTTON_DOUBLE_CLICK},
    {GT_BTN_YELLOW, BUTTON_SINGLE_CLICK},
    {GT_BTN_YELLOW, BUTTON_DOUBLE_CLICK},
    {GT_BTN_BLUE, BUTTON_SINGLE_CLICK},
    {GT_BTN_BLUE, BUTTON_DOUBLE_CLICK},
    {GT_BTN_RED, BUTTON_SINGLE_CLICK},
    {GT_BTN_RED, BUTTON_DOUBLE_CLICK},
};


// static const char* TAG = "task_button";


/* local fn definitions */


static void button_all_cb(void *, void *);


/* ========================================================================== */
void gt_btn_setup(void) {
    uint8_t i;

    const button_config_t btn_cfg_all = {0};

    const button_gpio_config_t btn_gpio_cfg[5] = {
        {
            .gpio_num = PIN_BUTTON_WHITE,
            .active_level = 0
        },
        {
            .gpio_num = PIN_BUTTON_GREEN,
            .active_level = 0
        },
        {
            .gpio_num = PIN_BUTTON_YELLOW,
            .active_level = 0
        },
        {
            .gpio_num = PIN_BUTTON_BLUE,
            .active_level = 0
        },
        {
            .gpio_num = PIN_BUTTON_RED,
            .active_level = 0
        }
    };
    button_handle_t gpio_btn[5] = {NULL, NULL, NULL, NULL, NULL};


    /* create queue */
    gt_btnq = xQueueCreate(EVENT_Q_SIZE, sizeof(struct gt_btn_msg_t*));

    /* create buttons */
    for (i = 0; i < NUM_BUTTONS; ++i) {
        ESP_ERROR_CHECK(iot_button_new_gpio_device(
                    &btn_cfg_all, &btn_gpio_cfg[i], &gpio_btn[i]));
    }


    /* register callbacks */
    for (i = 0; i < NUM_EVENTS; ++i) {
        ESP_ERROR_CHECK(iot_button_register_cb(gpio_btn[btn_evts[i].btn],
                    btn_evts[i].evt,
                    NULL,
                    &button_all_cb,
                    &btn_evts[i]));
    }
}


void button_all_cb(void *arg, void *user_data) {
    // struct gt_btn_msg_t *msg = (struct gt_btn_msg_t*) user_data;
    xQueueSendToBackFromISR(gt_btnq, (void *) &user_data, NULL);
}
