#include <stdio.h>
#include <inttypes.h>
#include "sdkconfig.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "driver/gpio.h"
#include "esp_log.h"

#include "task_imu.h"
#include "pins.h"
#include "task_lcd.h"
#include "task_button.h"
#include "task_wifi.h"
#include "sdcardspi.h"

static const char *TAG = "hello_world_main";

int gt_global_sdsupport;

void app_main(void)
{
    TaskHandle_t wifi_taskh;
    TaskHandle_t imu_taskh;

    printf("Hello world!\n");

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_BUTTON_WHITE));
    ESP_ERROR_CHECK(gpio_set_direction(PIN_BUTTON_WHITE, GPIO_MODE_INPUT));
    ESP_ERROR_CHECK(gpio_pullup_en(PIN_BUTTON_WHITE));

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_BUTTON_GREEN));
    ESP_ERROR_CHECK(gpio_set_direction(PIN_BUTTON_GREEN, GPIO_MODE_INPUT));
    gpio_pullup_en(PIN_BUTTON_GREEN);

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_BUTTON_YELLOW));
    ESP_ERROR_CHECK(gpio_set_direction(PIN_BUTTON_YELLOW, GPIO_MODE_INPUT));
    gpio_pullup_en(PIN_BUTTON_YELLOW);

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_BUTTON_BLUE));
    gpio_set_direction(PIN_BUTTON_BLUE, GPIO_MODE_INPUT);
    gpio_pullup_en(PIN_BUTTON_BLUE);

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_BUTTON_RED));
    gpio_set_direction(PIN_BUTTON_RED, GPIO_MODE_INPUT);
    gpio_pullup_en(PIN_BUTTON_RED);

    ESP_ERROR_CHECK(gpio_reset_pin(PIN_VIBRATOR));
    ESP_ERROR_CHECK(gpio_set_direction(PIN_VIBRATOR, GPIO_MODE_OUTPUT));
    ESP_ERROR_CHECK(gpio_set_drive_capability(PIN_VIBRATOR, GPIO_DRIVE_CAP_3));


    /* initialize the buttons */
    gt_btn_setup();

    gt_global_sdsupport = task_sdcard();

    /* register the wifi task */
    if (xTaskCreate(
                task_wifi_time,
                "wifi.ntime",
                4096,
                NULL,
                tskIDLE_PRIORITY,
                &wifi_taskh) != pdPASS) {
        ESP_LOGW(TAG, "failed to initialize wifi time update!");
    }



    /* start the main gui thread  which starts all else */

    if (xTaskCreate(task_imu_all,
    "task.imu", 4096, NULL, tskIDLE_PRIORITY, &imu_taskh) != pdPASS) {
        ESP_LOGW(TAG, "failed to initialize imu");
    }

    lcd_task();
    //task_imu_all(NULL);
    /*
    for (int i = 10; i >= 0; i--) {
        printf("Restarting in %d seconds...\n", i);
        vTaskDelay(1000 / portTICK_PERIOD_MS);
    }
    printf("Restarting now.\n");
    fflush(stdout);
    esp_restart();
    */
    /* initialize uart */
    while (1) {
        /*
        printf("Button levels: [%d|%d|%d|%d|%d]\n",
                gpio_get_level(PIN_BUTTON_WHITE),
                gpio_get_level(PIN_BUTTON_GREEN),
                gpio_get_level(PIN_BUTTON_YELLOW),
                gpio_get_level(PIN_BUTTON_BLUE),
                gpio_get_level(PIN_BUTTON_RED));
                */
        ESP_ERROR_CHECK(gpio_set_level(PIN_VIBRATOR, !gpio_get_level(PIN_BUTTON_RED)));
        vTaskDelay(100 / portTICK_PERIOD_MS);
    }
}
