/* 
 * File:   goldeloxSerial.h
 * Author: User
 *
 * Created on October 13, 2014, 10:26 PM
 */

#ifndef __GL_SERIAL_H__
#define __GL_SERIAL_H__

#include "Goldelox_Types4D.h"
#include "gl_error.h"

// SPE Version 1.1 added bus_ and pin_ functions

#define   Err4D_OK      0
#define   Err4D_Timeout 1
#define   Err4D_NAK		2 // other than ACK received

// 4D Global variables
extern int cPort ;                              // comp port handle, used by Intrinsic routines
extern int Error4D ;  				// Error indicator,  used and set by Intrinsic routines
extern unsigned char Error4D_Inv ;              // Error byte returned from com port, onl set if error = Err_Invalid
extern int TimeLimit4D ;			// time limit in ms for total serial command duration, 2000 (2 seconds) should be adequate for most commands
                                                // assuming a reasonable baud rate AND low latency AND 0 for the Serial Delay Parameter
                                                // temporary increase might be required for very long (bitmap write, large image file opens)
                                                // or indeterminate (eg file_exec, file_run, file_callFunction)  commands
extern int(*Callback4D) (int, unsigned char) ;	// Error callback. Set to NULL if no callback is required. i.e. all errors will be handled in your code
						// Set to callback routine in your program to enable you to diagnose and display errors. You can
						// simply return from the error routine if you so desire, but really, the correct thing to do is produce
						// an error message of some kind and terminate your application.
extern int Error_Abort4D;                       // Set TRUE to exit immediately from error handler;





#ifdef	__cplusplus
extern "C" {
#endif

/* new initialization functions */

/**
 * @brief Initialize a new Goldelox display.
 * @param disp The display object to use.
 * @param serif The serif to use w/ display.
 * @return error code
 */
gl_err_t gl_init(gl_display_t *disp, gl_serif_t *serif);

/**
 * @brief Return Character Height for the given char in
 * pixels.
 * @param display The display object to use
 * @param test_char Presumably, a test character?
 * @return The height of that character
 */
gl_word_t gl_charheight(gl_display_t *display, unsigned char test_char);

/**
 * @brief Return Character width for the given char in
 * pixels.
 * @param display The display object to use
 * @param test_char Presumably, a test character?
 * @return The width of that character
 */
gl_word_t gl_charwidth(gl_display_t *display, unsigned char TestChar) ;

/**
 * @brief Set the screen background color.
 * @param display The display object to use
 * @param color The color to set the background to.
 */
void gl_gfx_BGcolour(gl_display_t *display, gl_word_t color);

/**
 * @brief Changes all old colored pixels to new colored pixels.
 * @param display The display object to use
 * @param old The old color to find
 * @param new The new color to replace
 */
void gl_gfx_ChangeColour(gl_display_t *display, gl_word_t old, gl_word_t new);

/**
 * @brief Draw a circle (not filled).
 * @param display The display object to use
 * @param x The center X coordimate of the circle
 * @param y The center Y coordinate of the circle
 * @param rad The radius of the circle
 * @param col The color of the circle
 */
void gl_gfx_Circle(gl_display_t *display, gl_word_t x, gl_word_t y,
        gl_word_t rad, gl_word_t col);

/**
 * @brief Draw a circle (filled).
 * @param display The display object to use
 * @param x The center X coordimate of the circle
 * @param y The center Y coordinate of the circle
 * @param rad The radius of the circle
 * @param col The color of the circle
 */
void gl_gfx_CircleFilled(gl_display_t *display, gl_word_t x, gl_word_t y,
        gl_word_t rad, gl_word_t col);

/**
 * @brief Enables/disables Clipping.
 * @param display The display object to use
 * @param value zero = disabled, 1 = enabled.
 */
void gl_gfx_Clipping(gl_display_t *display, gl_word_t value);

/**
 * @brief All objects will only be visible in this region.
 *
 * Enable clipping first using gl_gfx_Clipping.
 * @param display The display object to use
 * @param x1 Horizontal Top Left position
 * @param y1 Vertical Top Left Position
 * @param x2 Horizontal Bottom Right position
 * @param y2 Vertical Bot Right Position
 */
void gl_gfx_ClipWindow(gl_display_t *display, gl_word_t x1, gl_word_t y1,
        gl_word_t x2, gl_word_t y2);

/**
 * @brief Clear screen using the defaults.
 *
 * Some settings may be reset, such as outline color, pen, origin and text
 * magnification. Consult the 4D Library manuals for more info.
 * @param display The display object to use
 */
void gl_gfx_Cls(gl_display_t *display);

/**
 * @brief Sets contrast, or turns display on/off depending on model.
 * @param display The display object to use
 * @param contrast Contrast 0 = Display OFF
 *     Contrast 1 - 15 = Contrast Level
 * 
 * @note uLCD-144-G2 does not support Contrast ‘levels’, values from 1-15 could
 * be set to turn the display ‘On’ and 0 to turn the Display ‘Off’.
 */
void gl_gfx_Contrast(gl_display_t *display, gl_word_t contrast);

/**
 * @brief sets frame delay for Media Video command
 * @param display The display object to use
 * @param msec 0-255 ms
 */
void gl_gfx_FrameDelay(gl_display_t *display, gl_word_t msec);

gl_word_t gl_gfx_GetPixel(gl_display_t *display, gl_word_t  X, gl_word_t  Y);

void gl_gfx_Line(gl_display_t *display, gl_word_t  X1, gl_word_t  Y1, gl_word_t  X2, gl_word_t  Y2, gl_word_t  Color) ;

void gl_gfx_LinePattern(gl_display_t *display, gl_word_t  Pattern) ;

void gl_gfx_LineTo(gl_display_t *display, gl_word_t  X, gl_word_t  Y) ;

void gl_gfx_MoveTo(gl_display_t *display, gl_word_t  X, gl_word_t  Y) ;

gl_word_t gl_gfx_Orbit(gl_display_t *display, gl_word_t  Angle, gl_word_t  Distance, gl_word_t *  Xdest, gl_word_t *  Ydest) ;

void gl_gfx_OutlineColour(gl_display_t *display, gl_word_t  Color) ;

void gl_gfx_Polygon(gl_display_t *display, gl_word_t  n, gl_word_array_t  Xvalues, gl_word_array_t  Yvalues, gl_word_t  Color) ;

void gl_gfx_Polyline(gl_display_t *display, gl_word_t  n, gl_word_array_t  Xvalues, gl_word_array_t  Yvalues, gl_word_t  Color) ;

void gl_gfx_PutPixel(gl_display_t *disp, gl_word_t  X, gl_word_t  Y, gl_word_t  Color) ;

void gl_gfx_Rectangle(gl_display_t *disp, gl_word_t  X1, gl_word_t  Y1, gl_word_t  X2, gl_word_t  Y2, gl_word_t  Color) ;

void gl_gfx_RectangleFilled(gl_display_t *display, gl_word_t  X1, gl_word_t  Y1, gl_word_t  X2, gl_word_t  Y2, gl_word_t  Color) ;

void gl_gfx_ScreenMode(gl_display_t *display, gl_word_t  ScreenMode) ;

void gl_gfx_SetClipRegion(gl_display_t *display) ;
void gl_blitComtoDisplay(gl_display_t *disp, gl_word_t  X, gl_word_t  Y, gl_word_t  Width, gl_word_t  Height, gl_byte_array_t  Pixels) ;
void gl_gfx_Set(gl_display_t *display, gl_word_t  Func, gl_word_t  Value) ;
void gl_gfx_Transparency(gl_display_t *display, gl_word_t  OnOff) ;
void gl_gfx_TransparentColour(gl_display_t *display, gl_word_t  Color) ;
void gl_gfx_Triangle(gl_display_t *display, gl_word_t  X1, gl_word_t  Y1, gl_word_t  X2, gl_word_t  Y2, gl_word_t  X3, gl_word_t  Y3, gl_word_t  Color) ;
gl_word_t gl_media_Flush(gl_display_t *display) ;
gl_word_t gl_media_Init(gl_display_t *display) ;
gl_word_t gl_media_ReadByte(gl_display_t *display) ;
gl_word_t gl_media_ReadWord(gl_display_t *display) ;
gl_word_t gl_media_WriteByte(gl_display_t *display, gl_word_t  Byte) ;
gl_word_t gl_media_WriteWord(gl_display_t *display, gl_word_t  Word) ;
void gl_media_Image(gl_display_t *display, gl_word_t  X, gl_word_t  Y) ;
void gl_media_SetAdd(gl_display_t *display, gl_word_t  HiWord, gl_word_t  LoWord) ;
void gl_media_SetSector(gl_display_t *display, gl_word_t  HiWord, gl_word_t  LoWord) ;
void gl_media_Video(gl_display_t *display, gl_word_t  X, gl_word_t  Y) ;
void gl_media_VideoFrame(gl_display_t *display, gl_word_t  X, gl_word_t  Y, gl_word_t  Framenumber) ;
void gl_putCH(gl_display_t *display, gl_word_t  WordChar) ;
void gl_putstr(gl_display_t *display, unsigned char *  InString) ;

void gl_txt_Attributes(gl_display_t *display, gl_word_t  Attribs) ;
void gl_txt_BGcolour(gl_display_t *display, gl_word_t  Color) ;
void gl_txt_Bold(gl_display_t *display, gl_word_t  Bold) ;
void gl_txt_FGcolour(gl_display_t *display, gl_word_t  Color) ;
void gl_txt_FontID(gl_display_t *display, gl_word_t  FontNumber) ;
void gl_txt_Height(gl_display_t *display, gl_word_t  Multiplier) ;
void gl_txt_Inverse(gl_display_t *display, gl_word_t  Inverse) ;
void gl_txt_Italic(gl_display_t *display, gl_word_t  Italic) ;
void gl_txt_MoveCursor(gl_display_t *display, gl_word_t  Line, gl_word_t  Column) ;
void gl_txt_Opacity(gl_display_t *display, gl_word_t  TransparentOpaque) ;
void gl_txt_Set(gl_display_t *display, gl_word_t  Func, gl_word_t  Value) ;
void gl_txt_Underline(gl_display_t *display, gl_word_t  Underline) ;
void gl_txt_Width(gl_display_t *display, gl_word_t  Multiplier) ;
void gl_txt_Xgap(gl_display_t *display, gl_word_t  Pixels) ;
void gl_txt_Ygap(gl_display_t *display, gl_word_t  Pixels) ;

void gl_BeeP(gl_display_t *display, gl_word_t  Note, gl_word_t  Duration) ;

gl_word_t gl_sys_GetModel(gl_display_t *display, unsigned char *  ModelStr) ;
gl_word_t gl_sys_GetPmmC(gl_display_t *display) ;
gl_word_t gl_sys_GetVersion(gl_display_t *display) ;

// AVOID ME SINCE I DON"T CHANGE ESP BAUD RATE
void gl_setbaudWait(gl_display_t *display, gl_word_t  Newrate, void (*cb)()) ;

void gl_pokeB(gl_display_t *display, gl_word_t  Address, gl_word_t  ByteValue) ;
void gl_pokeW(gl_display_t *display, gl_word_t  Address, gl_word_t  WordValue) ;
void gl_SSMode(gl_display_t *display, gl_word_t  Parm) ;
void gl_SSSpeed(gl_display_t *display, gl_word_t  Speed) ;
void gl_SSTimeout(gl_display_t *display, gl_word_t  Seconds) ;
gl_word_t gl_joystick(gl_display_t *display) ;
gl_word_t gl_peekB(gl_display_t *display, gl_word_t  Address) ;
gl_word_t gl_peekW(gl_display_t *display, gl_word_t  Address) ;

void gl_reset2(gl_display_t *);


gl_word_t gl_txt_strw(gl_display_t *, char *);



#ifdef	__cplusplus
}
#endif

#endif	/* GOLDELOXSERIAL_H */

