/**
 * @file bmp_reader.h
 * @brief Uncompressed BMP reader
 * @author Advaith Menon
 */

/* code adapted from 2035le's BMP loader */
#ifndef __BMP_READER_H__
#define __BMP_READER_H__

#ifdef __cplusplus
// extern "C" {
#endif

#include <stdio.h>
#include <stdint.h>

#include "goldeloxSerial.h"

struct bmp_header_t {
    char signature[2];
    int32_t size;
    int32_t _slack;
    int32_t offset;
};

struct bmp_info_header_t {
    int32_t header_size;
    uint32_t width;
    uint32_t height;
    int16_t planes;
    int16_t bits_per_pixel;
    int32_t compression;
    int32_t size;
    int32_t x_pixels_per_m;
    int32_t y_pixels_per_m;
    int32_t used_colors;
    int32_t important_colors;
};

/* color table is skipped because we support only 24 bit BMP*/

/* only use for fine grain control */
void bmp_read_header(FILE *, struct bmp_header_t *);
void bmp_read_info_header(FILE *, struct bmp_info_header_t *);
int bmp_procure_info(FILE *, struct bmp_header_t *, struct bmp_info_header_t *);
void bmp_read_bgr_data(FILE *, int *);
int bmp_blit(char *file, gl_display_t *, uint16_t, uint16_t);

#ifdef __cplusplus
// }
#endif
#endif

