#include <stdio.h>
#include <stdint.h>
#include "freertos/FreeRTOS.h"

#include "Goldelox_Types4D.h"
#include "Goldelox_const4D.h"
#include "goldeloxSerial.h"

#include "task_button.h"
#include "task_imu.h"
#include "task_lcd.h"
#include "app_health.h"

#define HEALTH_BANNER_HEIGHT 16
#define HEALTH_PAD 5

void app_health_data(gl_display_t *disp) {
    char data[64] = "watchdog test...";
    gl_gfx_Cls(disp);
    gl_txt_BGcolour(disp, BLACK);
    gl_txt_FGcolour(disp, WHITE);
    while (1) {
        gl_txt_MoveCursor(disp, 0, 0);
        struct gt_btn_msg_t *btnmsg;
        struct gt_health_msg_t healthmsg;
        gl_putstr(disp, (uint8_t *) "watch dog diagnosis");
        gl_txt_MoveCursor(disp, 5, 0);
        gl_putstr(disp, (uint8_t *) data);
        while (xQueueReceive(gt_btnq, (void *) &btnmsg, 0) == pdPASS) {
            if (btnmsg->btn == GT_BTN_WHITE
                    && btnmsg->evt == BUTTON_SINGLE_CLICK) {
                return;
            }
        }

        while (xQueueReceive(gt_healthq, (void *) &healthmsg, 0) == pdPASS) {
            snprintf(data, 64, "Steps: %d\nCalories: %.4f", healthmsg.step, healthmsg.cal);
        }
        printf(data);
        
        vTaskDelay(pdMS_TO_TICKS(100));
    }
}

void app_health_data2(gl_display_t *disp) {
    char data[64] = "loading...";
    char dat2[64] = "loading...";
    const char *title = "Exercise";
    const gl_word_t charht = gl_charheight(disp, 'x');
    gl_gfx_Cls(disp);


    
    uint16_t txtw = gl_txt_strw(disp, title);
    gl_gfx_RectangleFilled(disp, 0, 0, LCD_WIDTH, HEALTH_BANNER_HEIGHT, ROSYBROWN);
    gl_gfx_MoveTo(disp, LCD_WIDTH / 2 - txtw / 2, (HEALTH_BANNER_HEIGHT - charht) / 2);
    gl_txt_BGcolour(disp, ROSYBROWN);
    gl_txt_FGcolour(disp, WHITE);
    gl_txt_Bold(disp, 1);
    gl_putstr(disp, (uint8_t *) title);


    gl_txt_BGcolour(disp, BLACK);
    gl_txt_FGcolour(disp, WHITE);

    while (1) {
        // gl_txt_MoveCursor(disp, 0, 0);
        struct gt_btn_msg_t *btnmsg;
        struct gt_health_msg_t healthmsg;
        
        
        while (xQueueReceive(gt_btnq, (void *) &btnmsg, 0) == pdPASS) {
            if (btnmsg->btn == GT_BTN_WHITE
                    && btnmsg->evt == BUTTON_SINGLE_CLICK) {
                return;
            }
        }

        while (xQueueReceive(gt_healthq, (void *) &healthmsg, 0) == pdPASS) {
            snprintf(data, 64, "Steps: %d", healthmsg.step);
            snprintf(dat2, 64, "Calories: %d", (int) healthmsg.cal);
        }

        // printf(data);

        
        // gl_txt_MoveCursor(disp, 5, 0);
        txtw = gl_txt_strw(disp, data);
        gl_gfx_MoveTo(disp, LCD_WIDTH / 2 - txtw / 2, LCD_HEIGHT / 2 - charht - HEALTH_PAD);
        //for (char *x = &data[0]; *x == '\0' ; x++)
        gl_putstr(disp, (unsigned char *) data);

        txtw = gl_txt_strw(disp, dat2);
        gl_gfx_MoveTo(disp, LCD_WIDTH / 2 - txtw / 2, LCD_HEIGHT / 2 + HEALTH_PAD);
        gl_putstr(disp, (unsigned char *) dat2);
        vTaskDelay(pdMS_TO_TICKS(100));
    }
}