/**
 * Goldelox constants. Modified to be more C-like.
 */
#pragma once

#ifndef __GL_TYPES_H__
#define __GL_TYPES_H__

#include <stddef.h>
#include <stdint.h>

typedef unsigned short gl_word_t;
typedef unsigned long gl_dword_t;
typedef gl_word_t * gl_word_array_t;
typedef unsigned char * gl_byte_array_t;
typedef unsigned char * gl_sector_t;

/* new added types! */
/* Serial Interface */
struct gl_serif_t {
    int (*write_tx) (const void *, size_t);
    int (*read_rx) (void *, size_t, uint32_t);
    int (*flush_rx) ();
    int (*flush_tx) (uint32_t);
};


typedef struct gl_serif_t gl_serif_t;


/* "COM" port interface */
struct gl_display_t {
    struct gl_serif_t *serif;
};

typedef struct gl_display_t gl_display_t;
#endif
