#!/bin/bash
# This script is based on the below VV
# credit: https://forums.linuxmint.com/viewtopic.php?t=363173
# Bugs fixed include actually making \n do someting
# The voice is also (arguably) better
thresholdRamPercent=90 # Should be an integer

warningMessage=$'WARNING: RAM usage above '$thresholdRamPercent$' percentage.\nPlease free some RAM.'

sayMessage="Warning: your RAM usage is above $thresholdRamPercent percent! \
You must do something about it!"

while true ; do

    # Get used RAM % via free(1) .
    usedRamPercent=$(free | grep Mem | awk '{print $3/$2 * 100.0}' | sed 's/\..*$//g')

    # Get used RAM % via python's psutil.
    # usedRamPercent=$(python3 -c 'import psutil ; print(psutil.virtual_memory().percent)' | sed 's/\..*$//g')

    if [ $usedRamPercent -ge $thresholdRamPercent ] ; then
        # Send a notification
        notify-send -u critical -i dialog-warning "$warningMessage"
        # Speak it out.
        spd-say -t female3 -p +15 -R +25 -r +20 "$sayMessage"
        # Display the warning in a window.
        # Waits until "OK" is clicked / window closed.
        zenity --info --height=240 --width=480 --text "${warningMessage}\n\
        Press OK to continue monitoring. Close this dialog to quit monitoring." || exit 1
    fi

    # Refresh every 5 seconds
    sleep 5

done
