#! /bin/bash

# (Un) mount all rclone drives.
# Usage: ./CloudLaunch.sh [mount path] [un]
# It's probably a good idea to start the script with set -e if modifying
# anything
# Ask me how I know.

wd="$(pwd)"
# I used to place these scripts in /opt so that other users could benefit
# I have no idea why this check is in here, but I'm leaving it commented.
# if [ $(whoami) != 'advaith' ]; then
#     echo "invalid user"
#     exit 1
# fi

if [ $1 ]; then
    wd=$1
fi

echo "Working directory: $wd"

for store in $(rclone listremotes)
do
    if [ "$2" = "un" ]; then
        echo "unmount remote: ${store:0:-1}"
        if [ -d "${store:0:-1}" ]; then
            fusermount -u "$wd/${store:0:-1}"
            echo "remove dir: $wd/${store:0:-1}"
            rm -d "$wd/${store:0:-1}"
        else
            echo "Already unmounted, skipping..."
        fi
    else
        echo "mounting remote: ${store:0:-1}"
        if [ ! -d "${store:0:-1}" ]; then
            echo "create dir: $wd/${store:0:-1}"
            mkdir "$wd/${store:0:-1}"
        fi
        # Note that 777 is to allow me to execute files
        # It can be set to something more secure, but keep in mind rclone does
        # not support chmod
        rclone mount --file-perms=0777 --daemon  --log-level=DEBUG --log-file="$wd/rclone.-${store:0:-1}.log" "$store/" --vfs-cache-mode writes "$wd/${store:0:-1}"
    fi
done

