#!/usr/bin/python3
# Copyright (c) 2024-2025 Advaith Menon
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy 
# of this software and associated documentation files (the "Software"), to deal 
# in the Software without restriction, including without limitation the rights 
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
# copies of the Software, and to permit persons to whom the Software is 
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in 
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
# SOFTWARE.

"""Export Canvas TA roster to CSV"""

import requests
import argparse
import sys
import csv


def make_header(apikey):
    """Make Authorization Header"""
    return {"Authorization" : "Bearer {}".format(apikey)}


def request(apikey, url):
    r = requests.get(url, headers=make_header(apikey))
    return r.json(), r.links.get("next", {"url": None})["url"]


def to_csv(apikey, url, fp, fieldnames=None):
    writer = None
    i = 1
    while url:
        data, url = request(apikey, url)

        print("Page {} (size: {})".format(i, len(data)))

        if writer is None and data:
            fieldnames = fieldnames or data[0].keys()
            writer = csv.DictWriter(fp, fieldnames=fieldnames)
            writer.writeheader()
        else:
            writer.writerows(data)
        i += 1


def main(argc, argv):
    if argc < 4:
        print("usage: {} [api-key] [endpoint] [file-name]".format(argv[0]),
              file=sys.stderr)
        return

    with open(argv[3], 'w', newline='') as fp:
        fieldnames = argv[4].split(",") if len(argv) > 4 else None
        to_csv(argv[1], argv[2], fp, fieldnames=fieldnames)


if __name__ == "__main__":
    main(len(sys.argv), sys.argv)

