#! /bin/bash
# Copyright (c) 2024-2025 Advaith Menon
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy 
# of this software and associated documentation files (the "Software"), to deal 
# in the Software without restriction, including without limitation the rights 
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
# copies of the Software, and to permit persons to whom the Software is 
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in 
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
# SOFTWARE.

# This is a program to ensure that a laptop-turned desktop doesn't use the
# built-in screen. It only works with X Server and is designed to be run by
# LightDM on startup.
# Get currently playing music and store to a text file
# Linux-only

get_playing_ff() {
    IFS=$'\n' out=($(dbus-send --print-reply --dest=$1 \
    /org/mpris/MediaPlayer2 org.freedesktop.DBus.Properties.Get \
    string:'org.mpris.MediaPlayer2.Player' string:'Metadata'))

    TITLE=$(echo "${out[8]}" | grep -o -P "(?<=string \").+(?=\")")
    ALBUM=$(echo "${out[12]}" | grep -o -P "(?<=string \").+(?=\")")
    ARTIST=$(echo "${out[17]}" | grep -o -P "(?<=string \").+(?=\")")

    echo "$ARTIST - $TITLE"
}


if [ "$#" -lt "2" ]; then
    echo "usage: $0 FILENAME SERVICE"
    exit
fi

FILENAME=$1
SERVICE=$2
REFRESH=1
ACTUALNAME=$2

# get list of services
for srv in $(dbus-send --print-reply --dest=org.freedesktop.DBus \
    /org/freedesktop/DBus org.freedesktop.DBus.ListNames  | grep -o \
    "org\\.mpris\\.MediaPlayer2\\..*[^\"]"); do
    if [[ "$srv" == *"$SERVICE"* ]]; then
        ACTUALNAME="$srv"
    fi
done

while sleep $REFRESH; do
    get_playing_ff $ACTUALNAME > $FILENAME
done

